/*----------------------------------------------------------------------------
 * Name:    button.c
 * Purpose: 
 * Note(s): 
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/
#include	"button.h"

u8 ButtonDebounceTime;
u8 ButtonRepeatTime;
u8 ButtonCurrentStatus;
u8 ButtonPreviousStatus;

/*****************************************************************************************************
* @brief  Configures BUTTON I/O
* @retval None
*******************************************************************************************************/
void BTN_InterfaceConfigure(void)
{
   /* configure BUTTON as GPIO  */   
   AFIO_GPxConfig(BTN1_AFIO_PORT, BUTTON1, BTN1_AFIO_FUN); 
   AFIO_GPxConfig(BTN2_AFIO_PORT, BUTTON2, BTN2_AFIO_FUN); 
   AFIO_GPxConfig(BTN3_AFIO_PORT, BUTTON3, BTN3_AFIO_FUN); 
   AFIO_GPxConfig(BTN4_AFIO_PORT, BUTTON4, BTN4_AFIO_FUN); 	
   /* configure BUTTON as IN mode  */
   GPIO_DirectionConfig(BTN1_PORT, BUTTON1, GPIO_DIR_IN);
   GPIO_DirectionConfig(BTN2_PORT, BUTTON2, GPIO_DIR_IN);
   GPIO_DirectionConfig(BTN3_PORT, BUTTON3, GPIO_DIR_IN);
   GPIO_DirectionConfig(BTN4_PORT, BUTTON4, GPIO_DIR_IN);	
   /* configure BUTTON input enable */   
   GPIO_InputConfig(BTN1_PORT, BUTTON1, ENABLE); 
   GPIO_InputConfig(BTN2_PORT, BUTTON2, ENABLE); 
   GPIO_InputConfig(BTN3_PORT, BUTTON3, ENABLE); 
   GPIO_InputConfig(BTN4_PORT, BUTTON4, ENABLE); 
   /* configure BUTTON pull-up function enabled  */
   GPIO_PullResistorConfig(BTN1_PORT, BUTTON1, GPIO_PR_UP);	
   GPIO_PullResistorConfig(BTN2_PORT, BUTTON2, GPIO_PR_UP);	
   GPIO_PullResistorConfig(BTN3_PORT, BUTTON3, GPIO_PR_UP);	
   GPIO_PullResistorConfig(BTN4_PORT, BUTTON4, GPIO_PR_UP);		
   /* configure BUTTON EXIT wake up source */
	AFIO_EXTISourceConfig(BTN1_EXIT_CH, BTN1_ESS_PORT);
	AFIO_EXTISourceConfig(BTN2_EXIT_CH, BTN2_ESS_PORT);
	AFIO_EXTISourceConfig(BTN3_EXIT_CH, BTN3_ESS_PORT);
	AFIO_EXTISourceConfig(BTN4_EXIT_CH, BTN4_ESS_PORT);
	*((u32 *) HT_EXTI + BTN1_EXIT_CH) = BTN_DEBOUNCE;
	*((u32 *) HT_EXTI + BTN2_EXIT_CH) = BTN_DEBOUNCE;
	*((u32 *) HT_EXTI + BTN3_EXIT_CH) = BTN_DEBOUNCE;
	*((u32 *) HT_EXTI + BTN4_EXIT_CH) = BTN_DEBOUNCE;
	
   ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
	ButtonCurrentStatus = 0;
	ButtonPreviousStatus = 0;
}
/*****************************************************************************************************
* @brief  BUTTON I/O wake up enable
* @retval None
*******************************************************************************************************/
void BTN_WakeupConfig(ControlStatus state)
{
	EXTI_WakeupEventConfig(BTN1_EXIT_CH, EXTI_WAKEUP_LOW_LEVEL, state);
	EXTI_WakeupEventConfig(BTN2_EXIT_CH, EXTI_WAKEUP_LOW_LEVEL, state);
	EXTI_WakeupEventConfig(BTN3_EXIT_CH, EXTI_WAKEUP_LOW_LEVEL, state);
	EXTI_WakeupEventConfig(BTN4_EXIT_CH, EXTI_WAKEUP_LOW_LEVEL, state);
}
/*****************************************************************************************************
* @brief  get BUTTON wake up flag
* @retval TRUE or FALSE
*******************************************************************************************************/
bool BTN_GetWakeupFlag(void)
{	
	if(HT_EXTI->WAKUPFLG & ((1<<BTN1_EXIT_CH) | (1<<BTN2_EXIT_CH) | (1<<BTN3_EXIT_CH) | (1<<BTN4_EXIT_CH)))
		return TRUE;
	else 
		return FALSE;
}
/*****************************************************************************************************
* @brief  clear BUTTON wake up flag
* @retval None
*******************************************************************************************************/
void BTN_ClearWakeupFlag(void)
{
	HT_EXTI->WAKUPFLG = ((1<<BTN1_EXIT_CH) | (1<<BTN2_EXIT_CH) | (1<<BTN3_EXIT_CH) | (1<<BTN4_EXIT_CH));
}
/*****************************************************************************************************
* @brief  load BUTTON IO state
* @retval BUTTON status
*******************************************************************************************************/
static u8 load_button_IO(void)
{
	u8 bts = 0;

   bts |= BUTTON1_IN ? 0x00:0x04;
   bts |= BUTTON2_IN ? 0x00:0x01;
   bts |= BUTTON3_IN ? 0x00:0x02;
	bts |= BUTTON4_IN ? 0x00:0x08;
	
	return(bts);
}
/*****************************************************************************************************
* @brief  scan BUTTON I/O status
* @retval None
*******************************************************************************************************/
bool BTN_ScanButtonStatus(void)
{
	u8 bts;

   bts  = load_button_IO();
	
   if(bts ^ ButtonCurrentStatus)
   {
      ButtonCurrentStatus = bts;
      ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
      ButtonRepeatTime = BUTTON_REPEAT1_DURATION;
   }
   else
   {
      if(--ButtonDebounceTime == 0)
      {
         ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
			if(ButtonCurrentStatus ^ ButtonPreviousStatus)
			{
				ButtonPreviousStatus = ButtonCurrentStatus;
            ButtonRepeatTime--;
				return(TRUE);
			}
         else
         {
            if(--ButtonRepeatTime == 0)
            {
               ButtonRepeatTime = BUTTON_REPEAT2_DURATION;
               if(ButtonPreviousStatus != 0) return(TRUE);               
            }
         }
      }
   }
	return(FALSE);	
}
/*****************************************************************************************************
* @brief  get BUTTON status
* @retval BUTTON status
*******************************************************************************************************/
u8 BTN_GetScanStatus(void)
{
	return(ButtonCurrentStatus);
}
/*****************************************************************************************************
* @brief  get BUTTON status
* @retval BUTTON status
*******************************************************************************************************/
u8 BTN_GetButtonStatus(void)
{
	return(ButtonPreviousStatus);
}

